/*****************************************************************************
| FILE:         inc_fi_handler.h
| PROJECT:      G3g
| SW-COMPONENT: AmControllerPlugin
|------------------------------------------------------------------------------
| DESCRIPTION:  FI Messages over INC
|
|------------------------------------------------------------------------------
| COPYRIGHT:    (c) 2013 Robert Bosch GmbH
| HISTORY:
| Date      | Modification               | Author
| 03.06.13  | Initial revision           | Ranjit Katuri
| --.--.--  | ----------------           | -------, -----
|
|*****************************************************************************/

#ifndef INCLUDE_INC_FI_HANDLER_H_IF
#define INCLUDE_INC_FI_HANDLER_H_IF

// use Application Help Library
#ifndef AHL_S_IMPORT_INTERFACE_GENERIC
  #define AHL_S_IMPORT_INTERFACE_GENERIC
  #include "ahl_if.h"
#endif

#include "inc_fi_main.h"

#include <pthread.h>
#include <vector>

class inc_fi_handler : public ahl_tclBaseWork
{
private:
  //Explicit private constructors
  inc_fi_handler();
  inc_fi_handler(const inc_fi_handler&);

  /**
  * Pointer to the dispatcher
  */
  inc_fi_main*  m_ptrmain;
  /**
  * Application ID for which the handler is being created. (Though this can be obtained using scd, i am not using it)
  * In INC case, we will always be acting as a client. So here the app ID is always the app id of the server we are trying to talk with
  */
  uint16_t    m_u16appid;
  /**
  * Service ID for which the handler is being created.
  * In INC case, we will always be acting as a client. So here the service ID refers to the service we are trying to talk with
  */
  uint16_t    m_u16serviceid;
  /**
  * Register ID recieved after service registration
  */
  uint16_t    m_u16regid;
  /**
  * Major version
  */
  uint16_t        m_u16majorversion;
  /**
  * Minor version
  */
  uint16_t        m_u16minorversion;
  /**
  * Service state
  */
  uint8_t      m_u8servicestate;

  /**
  * Vector to hold the list of FIDs to be registered
  */
  std::vector<uint16_t>  m_fidupreglist;

  /**
  * Mutex to guard the upreg list
  */
  pthread_mutex_t      m_upregmutex;

  friend class inc_fi_main;

  void vSetServiceState(uint16_t u16RegisterId, uint8_t u8servicestate, uint16_t u16SubId);

  /**
  * Function triggered when service is available
  */
  virtual tVoid vOnServiceAvailable(){}
   /**
   * Function triggered when service is unavailable
   */
  virtual tVoid vOnServiceUnavailable(){}

  /**
  * Funciton invoked by inc_fi_main to register for a service
  */
  bool  bRegisterService();
  /**
  * Funciton invoked by inc_fi_main to unregister for a service
  */
  bool  bUnRegisterService();

  /**
  * Internal helper function to check and register for a FID
  */
  void vCheckAndRegisterFID();

  /**
  * Function invoked by inc_fi_main to set the service state
  */
  void vSetServiceState(uint8_t u8servicestate);

protected:
  /**
  * When a handler is being created, it has to be mentioned about what the APP ID and Service ID for which the handler is being created
  */
  inc_fi_handler(uint16_t u16AppID, uint16_t u16ServiceID, uint16_t u16majorversion, uint16_t u16minorversion);
  /**
  * Helper function to register for a property of a server
  */
  bool      bRegisterForFID(uint16_t u16FunctionID);
  /**
  * Helper function to unregister for a property of a server
  */
  bool      bUnRegisterForFID(uint16_t u16FunctionID);
  /**
  * Helper function to copy data to FI Message from
  */
  void      vCopyDatatoFIMessage(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData);
  /**
  * Helper function to send FI message over INC
  */
  bool      bPostFIMessage(uint16_t u16FID, uint8_t u8Opcode,fi_tclTypeBase& oOutData);
   /**
   * Helper function to check if service is available
   */
  tBool bIfServiceAvailable() const {return (m_u8servicestate == CCA_C_U8_SVCSTATUS_AVAILABLE);}

public:
  virtual ~inc_fi_handler();
};

#endif //INCLUDE_INC_FI_HANDLER_H_IF
